#include <iostream>
#include <vector>
#include <unordered_map>

using namespace std;

#define MAX 1000000000

typedef long long ll;

int main(){
  ios_base::sync_with_stdio(false), cin.tie(0);
  
  int n; cin>>n;
  vector<pair<int, int>> vec(n);
  unordered_map<ll, ll> xCtrEven, xCtrOdd, yCtrEven, yCtrOdd, diagonal1, diagonal2;

  ll res = 0;

  for (int i = 0; i < n; ++i){
    cin>>vec[i].first>>vec[i].second;

    int x = vec[i].first, y = vec[i].second;

    if (x % 2)
      ++xCtrOdd[y];
    else
      ++xCtrEven[y];

    if (y % 2)
      ++yCtrOdd[x];
    else
      ++yCtrEven[x];

    ++diagonal1[x - y];
    ++diagonal2[x + y];
  }

  for (auto p: vec){
    --diagonal1[p.first - p.second];
    res += diagonal1[p.first - p.second] * 2;

    --diagonal2[p.first + p.second];
    res += diagonal2[p.first + p.second] * 2;

    if (p.first % 2){
      --xCtrOdd[p.second];
      res += xCtrOdd[p.second];
    }
    else{
      --xCtrEven[p.second];
      res += xCtrEven[p.second];
    } 

    if (p.second % 2){
      --yCtrOdd[p.first];
      res += yCtrOdd[p.first];
    }
    else{
      --yCtrEven[p.first];
      res += yCtrEven[p.first];
    }
  }

  cout<<res;

  return 0;
}